package com.java24hours.leader;

import android.annotation.SuppressLint;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.content.Intent;
import android.net.Uri;
/**
 * Przykadowa aktywno penoekranowa, ktra wywietla i ukrywa systemowe UI (czyli.
 * pasek stanu oraz pasek nawigacyjny/systemowyr) w zalenoci od dziaa uytkownika.
 */
public class LeaderActivity extends AppCompatActivity {
    /**
     * Niezalenie od wszystkiego systemowe UI powinno by ukrywane automatycznie po 
     * {@link #AUTO_HIDE_DELAY_MILLIS} milisekundach.
     */
    private static final boolean AUTO_HIDE = true;

    /**
     * Jeli {@link #AUTO_HIDE} jest ustwaione, naley ustawi teliczb milisekund,
     * po upywie ktrych systemowe UI zostanie ukryte.
     */
    private static final int AUTO_HIDE_DELAY_MILLIS = 3000;

    /**
     * W niektrych starszych urzdzeniach wystpuje pewne opnienie midzy aktualizacj widetu UI
     * a zmian paskw nawigacyjnego i stanu.
     */
    private static final int UI_ANIMATION_DELAY = 300;
    private final Handler mHideHandler = new Handler();
    private View mContentView;
    private final Runnable mHidePart2Runnable = new Runnable() {
        @SuppressLint("InlinedApi")
        @Override
        public void run() {
            // opnione usunicie paskw nawigacyjnego i stanu

            // Zauwa, e niektre z tych staych s nowoci w API 16 (Jelly Bean)
            // i API 19 (KitKat). Mimo to mona ich bezpiecznie uywa,
            // poniewa w przypadku starszych urzdze nie bd brane pod uwwag.
            mContentView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LOW_PROFILE
                    | View.SYSTEM_UI_FLAG_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                    | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
                    | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                    | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION);
        }
    };
    private View mControlsView;
    private final Runnable mShowPart2Runnable = new Runnable() {
        @Override
        public void run() {
            // opnione wywietlanie elementw UI
            ActionBar actionBar = getSupportActionBar();
            if (actionBar != null) {
                actionBar.show();
            }
            mControlsView.setVisibility(View.VISIBLE);
        }
    };
    private boolean mVisible;
    private final Runnable mHideRunnable = new Runnable() {
        @Override
        public void run() {
            hide();
        }
    };
    /**
     * Element reagujcy na dotyk przeznaczony dla kontrolek interfejsu w celu ustalenia opnienia ukrywania
     * systemowego UI. Ma to zapobiega niewaciwym zachowanim kontrolek
     * wchodxzcych w interakcje z UI aktywnoci.
     */
    private final View.OnTouchListener mDelayHideTouchListener = new View.OnTouchListener() {
        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (AUTO_HIDE) {
                delayedHide(AUTO_HIDE_DELAY_MILLIS);
            }
            return false;
        }
    };

    public void processClicks(View display) {
        Intent action = null;
        int id = display.getId();
        switch (id) {
            case (R.id.phoneButton):
                action = new Intent(Intent.ACTION_DIAL, Uri.parse("tel:202-456-1111"));
                break;
            case (R.id.webButton):
                action = new Intent(Intent.ACTION_VIEW, Uri.parse("http://whitehouse.gov"));
                break;
            case (R.id.mapButton):
                action = new Intent(Intent.ACTION_VIEW, Uri.parse("geo:0,0?q=White House, Washington, DC"));
                break;
            default:
                break;
        }
        startActivity(action);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_leader);

        mVisible = true;
        mControlsView = findViewById(R.id.fullscreen_content_controls);
        mContentView = findViewById(R.id.fullscreen_content);


        // ustawienie interakcji uytkownika pod ktem rcznego wyietlania i ukrywania systemowgo UI
        mContentView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                toggle();
            }
        });

        // W przypadku interakcji z kontrolkami UI naley  opnia kad zaplanowan operacj hide(),
        // aby zapobiec dziwnym zachowaniom ukrywanych kontrolek. 
        // findViewById(R.id.dummy_button).setOnTouchListener(mDelayHideTouchListener);
    }

    @Override
    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);

        // Pierwsz operacjl hide() naley uruchomi wkrtce po utworzeniu aktywnoci,
        // aby pokaza uytkownikowi, e kontrolki s dostpne.
        delayedHide(100);
    }

    private void toggle() {
        if (mVisible) {
            hide();
        } else {
            show();
        }
    }

    private void hide() {
        // Najpierw naley ukry UI.
        ActionBar actionBar = getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        mControlsView.setVisibility(View.GONE);
        mVisible = false;

        // Zaplanuj ukrycie po krtkiej przerwie paskw nawigacyjnego i stanu. 
        mHideHandler.removeCallbacks(mShowPart2Runnable);
        mHideHandler.postDelayed(mHidePart2Runnable, UI_ANIMATION_DELAY);
    }

    @SuppressLint("InlinedApi")
    private void show() {
        // Wywietl pasek systemowy.
        mContentView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION);
        mVisible = true;

        // Zaplanuj wywietlenie po krtkiej przerwie elementw UI.
        mHideHandler.removeCallbacks(mHidePart2Runnable);
        mHideHandler.postDelayed(mShowPart2Runnable, UI_ANIMATION_DELAY);
    }

    /**
     * Planuje ukrywanie z onieniem wyraonym w milisekundach, 
     * anulujc zaplanowane wczeniej ukrywania.
     */
    private void delayedHide(int delayMillis) {
        mHideHandler.removeCallbacks(mHideRunnable);
        mHideHandler.postDelayed(mHideRunnable, delayMillis);
    }
}
